DROP TABLE IF EXISTS `site_core_skins`;
CREATE TABLE `site_core_skins` (
  `skin_id` int(11) NOT NULL AUTO_INCREMENT,
  `skin_parent` int(11) NOT NULL DEFAULT 0,
  `skin_name` varchar(200)   NOT NULL,
  `skin_status` int(1) NOT NULL,
  `skin_data` longtext NOT NULL,
  `skin_system` int(1) NOT NULL,
  `skin_base` text NOT NULL,
  `skin_css` longtext NOT NULL,
  `skin_default` int(1) NOT NULL DEFAULT 0,
  `skin_modules` text NOT NULL,
  `skin_modules_global` text NOT NULL,
  `skin_device` varchar(100) NOT NULL DEFAULT '1,2,3',
  PRIMARY KEY (`skin_id`),
  KEY `skin_status` (`skin_status`),
  KEY `skin_system` (`skin_system`),
  KEY `skin_default` (`skin_default`),
  KEY `skin_device` (`skin_device`),
  FULLTEXT KEY `skin_modules` (`skin_modules`),
  FULLTEXT KEY `skin_modules_global` (`skin_modules_global`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `site_core_skins` (`skin_id`, `skin_parent`, `skin_name`, `skin_status`, `skin_data`, `skin_system`, `skin_base`, `skin_css`, `skin_default`, `skin_modules`, `skin_modules_global`, `skin_device`) VALUES
(-1,	0,	'Default',	1,	'',	1,	'',	'',	0,	'',	'',	'1,2,3');

DROP TABLE IF EXISTS `site_core_skins_classes`;
CREATE TABLE `site_core_skins_classes` (
  `class_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(100) NOT NULL,
  `class_type` int(11) NOT NULL,
  PRIMARY KEY (`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_skins_fonts`;
CREATE TABLE `site_core_skins_fonts` (
  `skin_id` int(11) NOT NULL AUTO_INCREMENT,
  `skin_lang` varchar(3) NOT NULL,
  `skin_css` text NOT NULL,
  `skin_head` text NOT NULL,
  PRIMARY KEY (`skin_id`),
  KEY `skin_lang` (`skin_lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_skins_overlays`;
CREATE TABLE `site_core_skins_overlays` (
  `overlay_id` int(11) NOT NULL AUTO_INCREMENT,
  `overlay_name` varchar(200) NOT NULL,
  `overlay_css` text NOT NULL,
  `overlay_image` int(1) NOT NULL,
  `overlay_css_main` text NOT NULL,
  `overlay_css_after` text NOT NULL,
  PRIMARY KEY (`overlay_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_skins_overlays` (`overlay_id`, `overlay_name`, `overlay_css`, `overlay_image`, `overlay_css_main`, `overlay_css_after`) VALUES
(1,	'dotted & dark 50%',	'background: rgba(0,0,0, 0.5) url({IMAGE}) repeat;',	1,	'',	''),
(13,	'dotted & bright 50%',	'background: rgba(0,0,0, 0.5) url({IMAGE}) repeat;',	1,	'',	''),
(2,	'bright 50%',	'background: rgba(255,255,255, 0.5);',	0,	'',	''),
(3,	'dark 50%',	'background: rgba(0,0,0, 0.5);',	0,	'',	''),
(4,	'blur 10px',	'	',	0,	'filter: blur(10px);',	''),
(5,	'hue-rotate 90deg',	'',	0,	'filter: hue-rotate(90deg);',	''),
(6,	'grayscale 100%',	'',	0,	'filter: grayscale(100%);',	''),
(7,	'invert 100%',	'',	0,	'    filter: invert(100%);',	''),
(8,	'opacity 30%',	'',	0,	'filter: opacity(30%);',	''),
(9,	'saturate 500%',	'',	0,	' filter: saturate(500%);',	''),
(10,	'sepia 100%',	'',	0,	'filter: sepia(100%);',	''),
(11,	'contrast 200% & brightness 150%',	'',	0,	'filter: contrast(200%) brightness(150%);',	''),
(12,	'radial gradient w/ dark margins',	'background: -moz-radial-gradient(center, ellipse cover, rgba(229,229,229,0) 0%, rgba(121,121,121,0.23) 47%, rgba(0,0,0,0.48) 100%);\r\nbackground: -webkit-radial-gradient(center, ellipse cover, rgba(229,229,229,0) 0%,rgba(121,121,121,0.23) 47%,rgba(0,0,0,0.48) 100%);\r\nbackground: radial-gradient(ellipse at center, rgba(229,229,229,0) 0%,rgba(121,121,121,0.23) 47%,rgba(0,0,0,0.48) 100%);\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#00e5e5e5\', endColorstr=\'#7a000000\',GradientType=1 );',	0,	'',	'');


DROP TABLE IF EXISTS `site_core_skins_animations`;
CREATE TABLE `site_core_skins_animations` (
  `animate_class` varchar(255) NOT NULL,
  `animate_name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounce','bounce');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('flash','flash');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('pulse','pulse');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rubberBand','rubberBand');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('shake','shake');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('swing','swing');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('tada','tada');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('wobble','wobble');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceIn','bounceIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceInDown','bounceInDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceInLeft','bounceInLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceInRight','bounceInRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceInUp','bounceInUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceOut','bounceOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceOutDown','bounceOutDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceOutLeft','bounceOutLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceOutRight','bounceOutRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('bounceOutUp','bounceOutUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeIn','fadeIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInDown','fadeInDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInDownBig','fadeInDownBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInLeft','fadeInLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInLeftBig','fadeInLeftBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInRight','fadeInRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInRightBig','fadeInRightBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInUp','fadeInUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeInUpBig','fadeInUpBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOut','fadeOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutDown','fadeOutDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutDownBig','fadeOutDownBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutLeft','fadeOutLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutLeftBig','fadeOutLeftBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutRight','fadeOutRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutRightBig','fadeOutRightBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutUp','fadeOutUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('fadeOutUpBig','fadeOutUpBig');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('flipInX','flipInX');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('flipInY','flipInY');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('flipOutX','flipOutX');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('flipOutY','flipOutY');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('lightSpeedIn','lightSpeedIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('lightSpeedOut','lightSpeedOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateIn','rotateIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateInDownLeft','rotateInDownLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateInDownRight','rotateInDownRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateInUpLeft','rotateInUpLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateInUpRight','rotateInUpRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateOut','rotateOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateOutDownLeft','rotateOutDownLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateOutDownRight','rotateOutDownRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateOutUpLeft','rotateOutUpLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rotateOutUpRight','rotateOutUpRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('hinge','hinge');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rollIn','rollIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('rollOut','rollOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomIn','zoomIn');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomInDown','zoomInDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomInLeft','zoomInLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomInRight','zoomInRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomInUp','zoomInUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomOut','zoomOut');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomOutDown','zoomOutDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomOutLeft','zoomOutLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomOutRight','zoomOutRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('zoomOutUp','zoomOutUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideInDown','slideInDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideInLeft','slideInLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideInRight','slideInRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideInUp','slideInUp');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideOutDown','slideOutDown');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideOutLeft','slideOutLeft');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideOutRight','slideOutRight');
INSERT INTO `site_core_skins_animations` (`animate_class`, `animate_name`) VALUES ('slideOutUp','slideOutUp');
